; DRV100.CMD - INSTALL AP DRIVER COMMAND FILE
; RSX11M FPS100 FEB 80
; DRIVER.MAC DEVTABLE.MAC
;
 .ENABLE GLOBAL
 .ENABLE SUBSTITUTION
 .IFDF $MAST .GOTO 10
; SETUP
 @SETUP
;
 .10:
    .SETN NAP $NOAP
        .OPEN FPSMC.MAC
        .DATA A$$P11='NAP'
        .SETN APS NAP
        .SETN DIS 0
        .SETN CSR 176000
        .SETN VEC 170
        .SETN N 0
        .SETN CSRSIZ 120
 ;
 ; ENTER THE CSR LOCATIONS IN ASCENDING ORDER, STARTING WITH THE
 ; LOWEST LOCATION
 ;
 .80:
 ;
        .ASKN [::'CSR'] ZN ENTER CSR LOCATION FOR AP # 'N'
        .DATA APCSR'N'='ZN'
        .IF N = 0 .SETN $START ZN
        .SETN DIS'N' ZN-DIS-CSRSIZ
        .SETN DIS ZN
        .SETN CSR ZN
        .ASKN  [::'VEC'] ZN ENTER VECTOR LOCATION FOR AP # 'N'
        .DATA APVEC'N'='ZN'
        .SETN VEC ZN
        .DEC NAP
        .IF NAP = 0 .GOTO 100
        .INC N
        .SETN VEC VEC+4
        .SETN CSR CSR+CSRSIZ
        .GOTO 80
 .100:  .DATA FPS100=1
        .CLOSE
 ;
 ; FPSMC.MAC HAS BEEN GENERATED
;
 .SETS BLOCK "'CSR'"
 .SETS BLOCK "7"+BLOCK[2:4]
 .ASK ANS IS YOUR HOST CPU A PDP-11/70
 .IFT ANS .SETS BLOCK "17"+BLOCK
;
; READ PASS 1 FROM INSTALLATION TAPE
;
 .SETN $PASS 1
 @TREAD
;
; AP DRIVER AND DEVICE TABLES ASSEMBLY
;
        .SETN N $START/100
        .SETN M N*100
        .SETN L $START-M
        .SETN K CSR-$START
        .SETN K K+CSRSIZ
        .SETN J K/100
        .SETN P J*100
        .SETN I K-P
        .IF I <> 0 .SETN J J+1
        .SETN P J*100
        .OPEN APDEV.MAC
        .DATA .PSECT APDEV
        .DATA .=.+'L'
        .DATA APCOM0:: .BLKB 'CSRSIZ'
        .SETN CT 1
 .650:
        .DEC APS
        .IF APS = 0 .GOTO 600
        .SETN DIS DIS'APS'
        .DATA .=.+'DIS'
        .DATA APCOM'CT':: .BLKB 'CSRSIZ'
        .INC CT
        .GOTO 650
 .600:
        .DATA .END
        .CLOSE
        .OPEN APDEV.CMD
        .DATA LB:APDEV/-HD/PI,,LB:APDEV='$WUIC'APDEV
        .DATA /
        .DATA STACK=0
        .DATA PAR=APDEV:0:'P'
        .DATA //
        .CLOSE
;
; APDEV.CMD HAS BEEN GENERATED
; ASSEMBLE AP DUMMY DEVICE COMMON
;
 MAC APDEV=APDEV
; ASSEMBLE AP DRIVER
;
 MAC APDRV,APDRV=FPSMC,LB:[1,1]EXEMC/ML,[11,10]RSXMC/PA:1,SY:'$WUIC'DRIVER
;
;  ASSEMBLE DEVICE TABLES FOR DRIVER
;
 MAC DEVTBL,DEVTBL=FPSMC,LB:[1,1]EXEMC/ML,[11,10]RSXMC/PA:1,SY:'$WUIC'DEVTABLE
 SET /UIC=[1,1]
 TKB @'$WUIC'APDEV
 PIP LB:APDEV.*/PU
        .SETN N N-1000
    .OPEN LB:[1,2]UPAP.CMD;1
    .DATA SET /MAIN=APDEV:'BLOCK':'J':DEV
    .DATA INS LB:[1,1]APDEV
    .DATA LOA AP:
    .CLOSE
 SET /UIC='$WUIC'
        .OPEN APDRVBLD.CMD
        .DATA LB:APDRV/-HD/-MM,,LB:APDRV='$WUIC'APDRV,DEVTBL
        .DATA LB:[1,54]RSX11M.STB/SS,[1,1]EXELIB/LB
        .DATA /
        .DATA STACK=0
        .DATA PAR=DRVPAR:120000:4000
        .DATA //
        .CLOSE
 SET /UIC=[1,54]
 TKB @'$WUIC'APDRVBLD
 PIP LB:APDRV.*/PU
 SET /UIC='$WUIC'
 PIP APDRVBLD.*;*,APDEV.*;*,APDRV.*;*,DEVTBL.*;*/DE
 .EXIT
 